-- ScreenHSV Icon... this needs to be flexible.
local gc = Var("GameCommand");
local index = gc:GetIndex();
local name = gc:GetName();

local screen = SCREENMAN:GetTopScreen();
local callingScreen;
if screen then
	callingScreen = screen:GetName();
	--Trace("callingScreen = ".. callingScreen);
end;

--local curColor = GetThemeColor();

local ScreensAndPrefs = {
	ScreenOptionsFilterP1 = "FilterColorP1",
	ScreenOptionsFilterP2 = "FilterColorP2",
};

local t = Def.ActorFrame{
	-- label
	AutoText("frutiger")..{
		Text=name;
		InitCommand=cmd(horizalign,right;shadowlength,1;maxwidth,64;NoStroke);
		BeginCommand=function(self)
			if name ~= "Exit" then
				self:x(-(SCREEN_CENTER_X*0.825));
			end;
		end;
		GainFocusCommand=function(self)
			MESSAGEMAN:Broadcast("HSVFocusChanged",{ NewIndex = index, NewName = name })
			self:diffuse( color("1,1,1,1") );
		end;
		LoseFocusCommand=cmd(diffuse,color("0.5,0.5,0.5,1") );
		UpdateBackgroundColorMessageCommand=function(self,params)
			curColor = params.Color;
		end;
		OffFocusedCommand=function(self)
			--SetUserPref("ThemeColor", "#"..ColorToHex(curColor) );
			
			if ScreensAndPrefs[CallingScreen] ~= nil then
				SetUserPref(ScreensAndPrefs[callingScreen], "#"..ColorToHex(curColor) );
			end;
		end;
	};
	
	Def.Quad{
		Name="SliderRange";
		InitCommand=cmd(zoomto,SCREEN_WIDTH*0.8,4;y,4;diffusealpha,0.5;diffusetopedge,color("1,1,1,0.5");diffusebottomedge,color("0.5,0.5,0.5,0.5");blend,'BlendMode_Add');
		BeginCommand=function(self)
			if name == "Exit" then self:visible(false);
			else self:visible(true);
			end;

			if name == "Alp" then
				self:addy(-4);
			end;
		end;
	};
};

return t;